/**
* \file: CarPlayMain.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Harder / ADIT/SW1 / jharder@de.adit-jv.com
*
* \copyright (c) 2014 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include <adit_logging.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include "Common.h"

// Plugin-core headers
#include "AirPlayReceiverServer.h"
#include "CarPlayControlClient.h"

#ifndef DLT_CARPLAY_APID
#define DLT_CARPLAY_APID "CPLY"
#endif

LOG_DECLARE_CONTEXT(dipo);
LOG_DECLARE_CONTEXT(airplay);

// Needed by AirPlaySignal Handler implementation
namespace adit { namespace carplay {
void RegisterSignalHandler();
} }

using namespace adit::carplay;

static AirPlayReceiverServerRef        gAirPlayServer    = NULL;

int main(int argc, char* argv[])
{
    OSStatus                        err;

#if 0    // Allow carplayd to start only once
    sem_t *carplaydsem;
    carplaydsem = sem_open("CarplayStartup", O_CREAT|O_EXCL);
    if ( carplaydsem == NULL )
    {
        fprintf(stderr, "carplayd process is already running!\n");
        exit(1);
    }
#endif
    // register signal handler
    RegisterSignalHandler();

    int opt = 0;
    while ((opt = getopt(argc, argv, "v")) != -1)
    {
        switch (opt)
        {
        case 'v':
            // print versions
            fprintf(stdout, "CarPlay git tag                     : %s\n", CarPlaySourceVersion.c_str());
            fprintf(stdout, "Communications plug-in core version : %s\n",
                    CarPlayCommunicationsPluginVersion.c_str());
            fprintf(stdout, "developed with iOS                  : %s\n",
                    CarPlayDevelopedWithiOSVersion.c_str());
            exit(0);
            break;
        default:
            fprintf(stderr, "Usage: %s [-v]\n", argv[0]);
            exit(1);
            break;
        }
    }

    // register CarPlay at logging
    LOG_REGISTER_APP(DLT_CARPLAY_APID, "CarPlay");
    LOG_REGISTER_CONTEXT(dipo, "CPLY", "CarPlay service");

    // register Airplay context at logging
    LOG_REGISTER_CONTEXT(airplay, "AIRP", "CarPlay communication plug-in core");

    /// Create the AirPlay server. This advertise via Bonjour and starts listening for connections.

    err = AirPlayReceiverServerCreate( &gAirPlayServer );
    require_noerr( err, exit );

    err = CarPlayControlClientCreateWithServer( &gCarPlayControlClient, gAirPlayServer, CarPlayControlClientEventCallback, NULL );
    require_noerr( err, exit );

    gCarPlayControllers = CFArrayCreateMutable( NULL, 0, &kCFTypeArrayCallBacks );
    require_action( gCarPlayControllers, exit, (err = kNoMemoryErr) );

    // Start the server and run until the app quits.

    AirPlayReceiverServerStart( gAirPlayServer );
    CarPlayControlClientStart( gCarPlayControlClient );
    CFRunLoopRun();
    CarPlayControlClientStop( gCarPlayControlClient );
    AirPlayReceiverServerStop( gAirPlayServer );

exit:
    CFReleaseNullSafe( gCarPlayControllers );
    CFReleaseNullSafe( gCarPlayControlClient );
    CFReleaseNullSafe( gAirPlayServer );

    // unregister CarPlay at logging
    LOG_UNREGISTER_CONTEXT(dipo);
    LOG_UNREGISTER_CONTEXT(airplay);
    LOG_UNREGISTER_APP();

#if 0    // Allow carplayd to start only once
    sem_unlink("CarplayStartup");
    sem_close(carplaydsem);
#endif

    return( err ? 1 : 0 );
}
